/*:
 * @target MZ
 * @plugindesc Hide Destination While Overlay — バックログ/オプション表示中は目的地タイル(白点滅)を無効化・非表示
 * @author HS
 *
 * @param applyToBacklog
 * @text バックログ中に無効化
 * @type boolean
 * @default true
 *
 * @param applyToOptions
 * @text オプション重ね表示中に無効化
 * @type boolean
 * @default true
 */
(() => {
  'use strict';
  const PN = document.currentScript.src.split('/').pop().replace(/\.js$/,'');
  const P  = PluginManager.parameters(PN);
  const APPLY_BL = P.applyToBacklog !== 'false';
  const APPLY_OP = P.applyToOptions !== 'false';

  const isBacklogOpen = () => APPLY_BL && !!(window.HSBL && typeof HSBL.isOpen === 'function' && HSBL.isOpen());
  const isOptionsOpen = () => APPLY_OP && !!(window.HS && typeof HS.isOptionsOverlayOpen === 'function' && HS.isOptionsOverlayOpen());
  const overlayActive  = () => isBacklogOpen() || isOptionsOpen();

  // Overlay中は 目的地設定そのものをブロック
  const _setDestination = Game_Temp.prototype.setDestination;
  Game_Temp.prototype.setDestination = function(x, y) {
    if (overlayActive()) return;
    _setDestination.apply(this, arguments);
  };

  // Overlay中は既存の目的地をクリア＆スプライトを非表示（Scene_Mapのみ）
  const _SM_update = Scene_Map.prototype.update;
  Scene_Map.prototype.update = function() {
    _SM_update.apply(this, arguments);
    if (!overlayActive()) return;
    try {
      if ($gameTemp.isDestinationValid()) $gameTemp.clearDestination();
      if (this._destinationSprite) this._destinationSprite.visible = false;
    } catch(_) {}
  };
})();
